/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import com.sun.j3d.internal.Distance;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickShape;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;

public final class PickCylinderSegment
extends PickCylinder {
    Point3d end;

    public PickCylinderSegment() {
        this.end = new Point3d();
    }

    public PickCylinderSegment(Point3d point3d, Point3d point3d2, double d2) {
        this.origin = new Point3d(point3d);
        this.end = new Point3d(point3d2);
        this.radius = d2;
        this.calcDirection();
    }

    public void set(Point3d point3d, Point3d point3d2, double d2) {
        this.origin.set(point3d);
        this.end.set(point3d2);
        this.radius = d2;
        this.calcDirection();
    }

    private void calcDirection() {
        this.direction.x = this.end.x - this.origin.x;
        this.direction.y = this.end.y - this.origin.y;
        this.direction.z = this.end.z - this.origin.z;
    }

    public void getEnd(Point3d point3d) {
        point3d.set(this.end);
    }

    final boolean intersect(Bounds bounds, Point4d point4d) {
        Point4d point4d2 = new Point4d();
        if (bounds instanceof BoundingSphere) {
            Point3d point3d = ((BoundingSphere)bounds).getCenter();
            double d2 = ((BoundingSphere)bounds).getRadius();
            double d3 = Distance.pointToSegment(point3d, this.origin, this.end);
            return d3 <= (d2 + this.radius) * (d2 + this.radius);
        }
        if (bounds instanceof BoundingBox) {
            Point3d point3d = new Point3d();
            ((BoundingBox)bounds).getLower(point3d);
            Point3d point3d2 = ((BoundingBox)bounds).getCenter();
            double d4 = point3d2.x - point3d.x + this.radius;
            double d5 = d4 * d4;
            d4 = point3d2.y - point3d.y + this.radius;
            d5 += d4 * d4;
            d4 = point3d2.z - point3d.z + this.radius;
            d5 += d4 * d4;
            double d6 = Distance.pointToSegment(point3d2, this.origin, this.end);
            if (d6 > d5) {
                return false;
            }
            if (d6 < this.radius * this.radius) {
                return true;
            }
            if (((BoundingBox)bounds).intersect(this.origin, this.end, point4d2)) {
                return true;
            }
            Point3d point3d3 = new Point3d();
            ((BoundingBox)bounds).getUpper(point3d3);
            Point3d[][] point3dArrayArray = new Point3d[][]{{point3d3, new Point3d(point3d.x, point3d3.y, point3d3.z)}, {new Point3d(point3d.x, point3d3.y, point3d3.z), new Point3d(point3d.x, point3d.y, point3d3.z)}, {new Point3d(point3d.x, point3d.y, point3d3.z), new Point3d(point3d3.x, point3d.y, point3d3.z)}, {new Point3d(point3d3.x, point3d.y, point3d3.z), point3d3}, {point3d, new Point3d(point3d.x, point3d3.y, point3d.z)}, {new Point3d(point3d.x, point3d3.y, point3d.z), new Point3d(point3d3.x, point3d3.y, point3d.z)}, {new Point3d(point3d3.x, point3d3.y, point3d.z), new Point3d(point3d3.x, point3d.y, point3d.z)}, {new Point3d(point3d3.x, point3d.y, point3d.z), point3d}, {point3d, new Point3d(point3d.x, point3d.y, point3d3.z)}, {new Point3d(point3d.x, point3d3.y, point3d.z), new Point3d(point3d.x, point3d3.y, point3d3.z)}, {new Point3d(point3d3.x, point3d3.y, point3d.z), new Point3d(point3d3.x, point3d3.y, point3d3.z)}, {new Point3d(point3d3.x, point3d.y, point3d.z), new Point3d(point3d3.x, point3d.y, point3d3.z)}};
            for (int i2 = 0; i2 < point3dArrayArray.length; ++i2) {
                double d7 = Distance.segmentToSegment(this.origin, this.end, point3dArrayArray[i2][0], point3dArrayArray[i2][1]);
                if (!(d7 <= this.radius * this.radius)) continue;
                return true;
            }
            return false;
        }
        if (bounds instanceof BoundingPolytope) {
            Point3d point3d = new Point3d();
            BoundingSphere boundingSphere = new BoundingSphere(bounds);
            boundingSphere.getCenter(point3d);
            double d8 = boundingSphere.getRadius();
            double d9 = Distance.pointToSegment(point3d, this.origin, this.end);
            if (d9 > (d8 + this.radius) * (d8 + this.radius)) {
                return false;
            }
            if (bounds.intersect(this.origin, this.direction, point4d2)) {
                return true;
            }
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            Point3d point3d4 = new Point3d();
            for (int i3 = 0; i3 < boundingPolytope.nVerts; ++i3) {
                int n2 = i3;
                while (i3 < boundingPolytope.nVerts) {
                    double d10;
                    point3d4.x = (boundingPolytope.verts[i3].x + boundingPolytope.verts[n2].x) * 0.5;
                    point3d4.y = (boundingPolytope.verts[i3].y + boundingPolytope.verts[n2].y) * 0.5;
                    point3d4.z = (boundingPolytope.verts[i3].z + boundingPolytope.verts[n2].z) * 0.5;
                    if (PickCylinder.pointInPolytope(boundingPolytope, point3d4.x, point3d4.y, point3d4.z) && (d10 = Distance.segmentToSegment(this.origin, this.end, boundingPolytope.verts[i3], boundingPolytope.verts[n2])) <= this.radius * this.radius) {
                        return true;
                    }
                    ++i3;
                }
            }
            return false;
        }
        return false;
    }

    PickShape transform(Transform3D transform3D) {
        PickCylinderSegment pickCylinderSegment = new PickCylinderSegment();
        pickCylinderSegment.origin.x = this.origin.x;
        pickCylinderSegment.origin.y = this.origin.y;
        pickCylinderSegment.origin.z = this.origin.z;
        pickCylinderSegment.radius = this.radius * transform3D.getScale();
        pickCylinderSegment.end.x = this.end.x;
        pickCylinderSegment.end.y = this.end.y;
        pickCylinderSegment.end.z = this.end.z;
        transform3D.transform(pickCylinderSegment.origin);
        transform3D.transform(pickCylinderSegment.end);
        pickCylinderSegment.direction.x = pickCylinderSegment.end.x - pickCylinderSegment.origin.x;
        pickCylinderSegment.direction.y = pickCylinderSegment.end.y - pickCylinderSegment.origin.y;
        pickCylinderSegment.direction.z = pickCylinderSegment.end.z - pickCylinderSegment.origin.z;
        pickCylinderSegment.direction.normalize();
        return pickCylinderSegment;
    }
}

